var	onScreenCanvasHandle,
	onScreenCanvasContext,
	offScreenCanvas,
	offScreenCanvasContext,
	progressBarLength	= 1,
	progressBarIndex	= 0,
	updateProgressBarInterval,
	fxToInitialize		= [],
	timeGlobal, timeGlobalBegin,
	renderAreaHandle,
	currentFxTimeline, currentOverlaysTimeline, currentTransitionTimeline
	audio_aka_shameOnMe


/*
 *	initialization
 */
onload=function()
{
	renderAreaHandle = document.getElementById('renderArea')

	audio_aka_shameOnMe = new Audio('data/space mod.wav')
	audio_aka_shameOnMe.onload = function(){progressBarIndex++}

	//	onScreenCanvas
	onScreenCanvasHandle	= document.getElementById('renderTargetCanvas');
	onScreenCanvasContext	= onScreenCanvasHandle.getContext('2d');

	onScreenCanvasHandle.width	= 640;
	onScreenCanvasHandle.height	= 320;

	//	offScreenCanvas
	offScreenCanvas			= document.createElement('canvas'),
	offScreenCanvasContext	= offScreenCanvas.getContext('2d');
	offScreenCanvas.width	= 320;
	offScreenCanvas.height	= 160;


	//	load the scripts
	scriptsLoader( 'scripts/includes/', '.inc.js' );
	scriptsLoader( 'scripts/fx/', '.fx.js', true );

	//	updateProgressBar
	updateProgressBarInterval = setInterval( updateProgressBar, 100 )
//	updateProgressBar()
}

function debug( msg )
{
	opera.postError( msg )
}

//	UGLY	unique
Array.prototype.getUnique = function()
{
	var output = [];
	for( var i=0; i<this.length; i++ )
	{
		var isUnique = true;
		for( var j=i+1; j<this.length && isUnique; j++ )
			isUnique = this[j]!=this[i];
		if( isUnique )
			output.push( this[i] )
	}
	return output;
}

/*
 *	sciptsLoader
 */
function scriptsLoader( path, typeOfScript, isFx )
{
	var headHandler		= document.getElementsByTagName('head')[0],
		xhr				= new XMLHttpRequest(),
		currentScript;

	xhr.open( 'GET', path, false );
	xhr.send();
	var filteredXhr = xhr.responseText.match( new RegExp( '[a-z0-9_.]+'+typeOfScript, 'gi' ) ).getUnique();

	while( currentScript=filteredXhr.pop() )
	{
		var tmpScript = document.createElement('script');
		tmpScript.src = path+currentScript;
		headHandler.appendChild( tmpScript );
		if( isFx )
		{
			if( !window.fxList )
				window.fxList = {}
			var scriptName = currentScript.substr( 0, currentScript.length-typeOfScript.length );
			fxList[ scriptName ] = true;
			fxToInitialize.push( scriptName );
			progressBarLength++;
		}
	}
}

/*
 *	updateProgressBar
 */
function updateProgressBar()
{
	if( fxToInitialize.length )
	{
		var fxName = fxToInitialize.shift()
		setTimeout(  fxName+'_init()', 1 )
	}

	//	TODO: a shiny progressBar

	onScreenCanvasContext.clearRect( 0,0,640,320 );

	onScreenCanvasContext.fillStyle = '#fff'
	onScreenCanvasContext.fillRect( 0,160-40,640*progressBarIndex/progressBarLength,80 );



	//	GO!
	if( progressBarIndex==progressBarLength )
		setTimeout( "document.getElementById('loading').style.display='none';updateProgressBarInterval=clearInterval( updateProgressBarInterval );timeGlobalBegin=timeGlobal=(new Date()).valueOf();updateDemo()", 1 )
}


window.createSVGElement = function( nodeName, attributesList )
{
	var svgElement = document.createElementNS( 'http://www.w3.org/2000/svg', nodeName );
	if( attributesList!=undefined )
		for( var key in attributesList )
			if( typeof(key)=='string' )
				svgElement.setAttribute( key, attributesList[key] );

	return svgElement;
}





var mouseButton = 0;
onmousedown = function(){ mouseButton=1 }
markedTimes = []

/*
 *	updateDemo
 */
function updateDemo()
{

	currentTime = timeGlobal-timeGlobalBegin

	if( mouseButton )
	{
		markedTimes.push( currentTime )
		mouseButton = 0
	}
	//top .status = Math.floor( currentTime/60000 )+'" '+ (Math.floor( currentTime/1000 )%60 )+"' "+( currentTime%1000 )+" >> "+ markedTimes.join( ", " )


	// update Timelines



	// update Fade
/*
	while( timelines[ 'fade' ].length && timelines[ 'fade' ][ 0 ][ 0 ]<=currentTime )
		currentFadeTimeline = timelines[ 'fade' ].shift()
	if( !currentFadeTimeline[1] )
		currentFadeTimeline[1] = overlayHandleArray['overlayFade'].style.backgroundColor
	if( !currentFadeTimeline[2] )
		currentFadeTimeline[2] = 500


	if( currentTime>= currentFadeTimeline[0] && currentTime<= currentFadeTimeline[0]+currentFadeTimeline[2] )
	{
		overlayHandleArray['overlayFade'].style.backgroundColor = currentFadeTimeline[1]
		overlayHandleArray['overlayFade'].style.opacity			= .9999-(currentTime-currentFadeTimeline[0])/currentFadeTimeline[2]
	}
	else
		overlayHandleArray['overlayFade'].style.opacity = 0
*/

	// update Overlays
/*
	for( var i=0; i<3; i++ )
	{
		previousOverlayTimelineLength = timelines[ 'overlay'+i ].length
		while( timelines[ 'overlay'+i ].length && timelines[ 'overlay'+i ][ 0 ][ 0 ]<=currentTime )
			currentOverlayTimeline[i] = timelines[ 'overlay'+i ].shift()

		if( !currentOverlayTimeline[i] || !currentOverlayTimeline[i][1] )
		{
			overlayHandleArray['overlay'+i].style.display = "none"
		}
		else
		{
			newOverlay = previousOverlayTimelineLength!=timelines[ 'overlay'+i ].length

			// handle the overlays
			switch( currentOverlayTimeline[i][1] )
			{
				case 'moomin':
				{
					with( overlayHandleArray['overlay'+i] )
					{
						if( newOverlay )
						{
							src = imagesPreloaded['moomin.gif'].src
								z = 4+Math.cos(currentTime/512)
							style.width		= (z*5) +"em"
							style.height	= "48em"
							style.top	=	0
							style.left	= (43-z*4)+"em"
						}
						else
						{
							var
								z = 4+Math.cos(currentTime/512)
							style.width		= (z*5) +"em"
							style.height	= z+"em"
							style.top	=	(45-z/2)+"em"
							style.left	= (43-z*4)+"em"
						}
					}
					break;
				}

				default:
				{
					with( overlayHandleArray['overlay'+i] )
					{
						if( newOverlay )
						{
							src = imagesPreloaded[currentOverlayTimeline[i][1]].src
							style.left		=
							style.top		= 0
							style.width		= "64em"
							style.height	= "48em"
						}
					}
					break;
				}
			}
			overlayHandleArray['overlay'+i].style.display = ""
		}
	}
*/


	// update Fx
	while( timelines[ 'fx' ].length && timelines[ 'fx' ][ 0 ][ 0 ]<=currentTime )
	{
		//	destroy previous fx
		if( currentFxTimeline && window[ currentFxTimeline[1]+'_destroy' ] )
			window[ currentFxTimeline[1]+'_destroy' ]()
		currentFxTimeline = timelines[ 'fx' ].shift()
	}
	if( currentFxTimeline )
	{
		//	render current fx
		var fxName	= currentFxTimeline[1]
		if( window[ fxName+'_render' ] )
			window[ fxName+'_render' ]( currentTime-currentFxTimeline[0], (currentTime-currentFxTimeline[0])/currentFxTimeline[2], currentFxTimeline[3] )
		else
			top.document.title = fxName+'_render DOES NOT EXIST ... '+ typeof( window[ fxName+'_render' ] )
	}



	// update Overlays
	while( timelines[ 'overlays' ].length && timelines[ 'overlays' ][ 0 ][ 0 ]<=currentTime )
		currentOverlaysTimeline = timelines[ 'overlays' ].shift()

	if( currentOverlaysTimeline && currentOverlaysTimeline[1] )
	{
		var relativeTime = currentTime-currentOverlaysTimeline[0];
		for( var i=0,currentOverlay; currentOverlay=currentOverlaysTimeline[1][i]; i++ )
		{
			if( overlays[ currentOverlay.id ] )
			{
				var	s	= currentOverlay.s+relativeTime*(currentOverlay.si||0),
					w	= s*overlays[currentOverlay.id].width,
					h	= s*overlays[currentOverlay.id].height

				offScreenCanvasContext.save()
				offScreenCanvasContext.translate( currentOverlay.x+relativeTime*(currentOverlay.xi||0),currentOverlay.y+relativeTime*(currentOverlay.yi||0) )
				offScreenCanvasContext.rotate( -currentOverlay.a-relativeTime*(currentOverlay.ai||0) )
				offScreenCanvasContext.drawImage( overlays[currentOverlay.id], -w/2,-h/2, w, h )

				offScreenCanvasContext.restore()
			}
		}
	}



	//	update Transition
	while( timelines[ 'transition' ].length && timelines[ 'transition' ][ 0 ][ 0 ]<=currentTime )
		currentTransitionTimeline = timelines[ 'transition' ].shift()

	if( currentTransitionTimeline )
	{
		if( window[ 'transition_render' ] )
			window[ 'transition_render' ]( currentTime-currentTransitionTimeline[0], (currentTime-currentTransitionTimeline[0])/currentTransitionTimeline[2], currentTransitionTimeline[1], currentTransitionTimeline[3], currentTransitionTimeline[4] )
	}




	//	clear screen and copy offScreen buffer
	onScreenCanvasContext.clearRect( 0,0,640,320 );
	onScreenCanvasContext.drawImage( offScreenCanvas,0,0,320,160,0,0,640,320);

	var	currentTime		= (new Date()).valueOf(),
		timeDifference	= currentTime-timeGlobal
	top.status = "neja nova | "+ Math.round( 1000/timeDifference )+" fps"
	setTimeout( updateDemo, 1 )
	timeGlobal = currentTime
}
